import dbus
from datetime import datetime
from dbus.mainloop.glib import DBusGMainLoop

# TODO: kommentieren
def timestampToDateTime(timestamp):
    time = datetime.fromtimestamp(timestamp)
    #return "{0}{1}{2}{3}{4}.{5}".format(time.year,time.month,time.day,time.hour,time.minute,time.second)
    return "{0} {1}:{2}:{3}".format(time.date(),time.hour,time.minute,time.second)

DBusGMainLoop(set_as_default=True)

bus = dbus.SystemBus()

usage_obj = bus.get_object('org.freesmartphone.ousaged', '/org/freesmartphone/Usage')
usage_iface = dbus.Interface(usage_obj, 'org.freesmartphone.Usage')

usage_iface.RequestResource("GPS")

gps_daemon = bus.get_object("org.freesmartphone.ogpsd",
				"/org/freedesktop/Gypsy")

gps_time_iface = dbus.Interface(gps_daemon,
				"org.freedesktop.Gypsy.Time")

# folgende funktionen sollten auf dbus-signale reagieren und nicht pollen
# rausbekommen, ob schon gefixt wurde
# anzahl der satteliten rauskriegen und wenn die mehr als 3 ist zeit nehmen
print(timestampToDateTime(gps_time_iface.GetTime()))

usage_iface.ReleaseResource("GPS")
